
from models.NormalType import NormalModel
from datatypes.Meta import datatypes

class responseModel(NormalModel):

    id = datatypes.AutoInt(name = "id" , title = "主键ID" , primaryKey = True , readOnly = 1)
    examiner = datatypes.Member(title = "考核人" , name = "examiner" , createDefault = False , autoAssign = False , readOnly = 0 , default = None , formula = "")
    dateOfExamination = datatypes.Date(title = "考试日期" , formatDate = "YYYY年MM月DD日" , dateTimeType = "DAY" , name = "dateOfExamination" , dateTimeFormat = "YYYY-MM-DD" , createDefault = False , updateDefault = False , autoAssign = False , readOnly = 0 , default = None , formula = "")
    testPapers = datatypes.RelateData(title = "试卷" , name = "testPapers" , relateType = "mto" , generic = "models.testTable" , relateField = "id" , relateFieldType = "AutoInt")
    otherOrganiser = datatypes.Datetime(title = "开始时间" , dateTimeFormat = "YYYY-MM-DD HH:mm:ss" , formatDate = "YYYY-MM-DD" , formatTime = "HH:mm:ss" , dateTimeType = "SECOND" , createDefault = False , updateDefault = False , name = "otherOrganiser")
    submissionTime = datatypes.Datetime(title = "交卷时间" , dateTimeFormat = "YYYY-MM-DD HH:mm:ss" , formatDate = "YYYY-MM-DD" , formatTime = "HH:mm:ss" , dateTimeType = "SECOND" , createDefault = False , updateDefault = False , name = "submissionTime" , autoAssign = False , readOnly = 0 , default = None , formula = "")
    score = datatypes.Numeric(title = "得分" , decimal = 0 , unit = "" , placeholder = "" , name = "score")
    comments = datatypes.Ltext(title = "评语" , isAllowScan = False , name = "comments")
    status = datatypes.Dropdown(title = "状态" , selectionWay = "custom" , options = [{"label": "未开始", "value": "unbegun", "style": {"backgroundColor": "#CDE7FF", "color": "#CDE7FF"}}, {"label": "答题中", "value": "answering ", "style": {"backgroundColor": "#DBE1FF", "color": "#DBE1FF"}}, {"label": "已答卷", "value": "answered", "style": {"backgroundColor": "rgb(254,238,202)", "color": "rgb(254,238,202)"}}, {"label": "已阅卷", "value": "finished", "style": {"backgroundColor": "rgb(189,223,219)", "color": "rgb(189,223,219)"}}] , name = "status" , color = True , placeholder = "" , allowManualInput = False , mulLevelSelectionConfig = {"sortFieldName": "", "sortBy": "", "matchFieldName": "", "dataSourceModel": "", "filterValue": ""})
    detailsOfResponses = datatypes.SubTable(title = "答卷明细" , name = "detailsOfResponses" , relateField = "relateResponses" , relateFieldType = "RelateData" , generic = "models.responseDetailModel" , relateType = "sub")

    class Meta:
        modelType = "NormalType"
        db = "databases.Default"
        dataTitle = None
        dbTable = "responseModel"
        name = "responseModel"
        baseModel = ""
        unionIndexList = []
        unionUniqueList = []
        