import type { ComponentPageScheme } from "jit";
import { Jit } from "jit";
import schemeJson from "./scheme.json";
import BlankComponent1 from "./BlankComponent1";
type BaseComponent = InstanceType<typeof Jit.BaseComponent>;

class PageCls extends Jit.GridPage {
    BlankComponent1!: BaseComponent = new BlankComponent1();
    myResponse!: BaseDataType;
    responseId!: BaseDataType;
    scheme: ComponentPageScheme = schemeJson;

    bindEvent() {
        this.subscribeEvent("afterRender", async () => {
            this.myResponse.value = await this.app.models.responseModel.get(Q(Q("id", "=", this.responseId.value)), null, 3);
        });
    }
}

export default PageCls;