import type { ComponentPageScheme } from "jit";
import { Jit } from "jit";
import schemeJson from "./scheme.json";
type BaseComponent = InstanceType<typeof Jit.BaseComponent>;

class PageCls extends Jit.GridPage {
    Form3!: BaseComponent;
    List2!: BaseComponent;
    Filter1!: BaseComponent;
    scheme: ComponentPageScheme = schemeJson;

    bindEvent() {
        this.Filter1.subscribeEvent("afterFilter", async () => {
            this.List2.call(this.Filter1.filter.value);
        });

        this.Form3.subscribeEvent("bXohQn", async () => {
            const globalConfirmResult1 = await this.newVariable({
                "name": "globalConfirmResult1",
                "title": "确认结果1",
                "dataType": "Dropdown",

                "options": [{
                    "value": "true",
                    "label": "确定"
                }, {
                    "value": "false",
                    "label": "取消"
                }]
            }, await this.app.modules.FeedBack.globalConfirm("确定要删除？"));

            if (globalConfirmResult1.isEqual("true")) {
                await this.app.models.testTable.deleteByFilter(Q(Q("id", "=", this.Form3.formData.id.value)));
                this.Form3.mode.value = "add";
                this.Form3.formData.reset();
                this.List2.call(undefined);
            }
        });

        this.Form3.subscribeEvent("titleDetails-delBtn", async () => {
            this.Form3.formData.total.value = this.Form3.formData.titleDetails.fractionalValue.sum;
        });

        this.Form3.subscribeEvent("titleDetails-fractionalValue-change", async () => {
            this.Form3.formData.total.value = this.Form3.formData.titleDetails.fractionalValue.sum;
        });

        this.Form3.subscribeEvent("BugRrS", async () => {
            const RowList11 = await this.newVariable({
                "name": "RowList11",
                "title": "题库明细1",
                "dataType": "RowList",
                "isNew": false,
                "generic": "models.detailedTitleOfTheTestPaper",
                "userDefine": "funcScope"
            }, await this.app.services.examinationServices.randomQuestion());

            this.Form3.formData.titleDetails.value = RowList11.value;
            this.Form3.formData.total.value = this.Form3.formData.titleDetails.fractionalValue.sum;
        });

        this.Form3.subscribeEvent("titleDetails-title-change", async () => {
            this.Form3.titleDetailsoperatedRow.fractionalValue.value = this.Form3.titleDetailsoperatedRow.title.fractionalValue.value;
            this.Form3.formData.total.value = this.Form3.formData.titleDetails.fractionalValue.sum;
        });

        this.Form3.subscribeEvent("afterSubmit", async () => {
            this.List2.call(undefined);
        });

        this.List2.subscribeEvent("clickDjlLps", async () => {
            this.Form3.mode.value = "add";
            this.Form3.formData.reset();
        });

        this.List2.subscribeEvent("clickRow", async () => {
            this.Form3.mode.value = "edit";
            this.Form3.formData.value = this.List2.activeRow.value;
        });
    }
}

export default PageCls;