
from models.NormalType import NormalModel
from datatypes.Meta import datatypes

class QuestionModel(NormalModel):
    id = datatypes.AutoInt(name = "id" , title = "ID" , primaryKey = True , readOnly = 1)
    categoryOfTopics = datatypes.Dropdown(title = "Category Of Topics" , selectionWay = "custom" , options = [{"label": "Needs Exploration", "value": "", "style": {"backgroundColor": "#FFDDDA", "color": "#FFDDDA"}}, {"label": "Competitor Comparison", "value": "", "style": {"backgroundColor": "#FEEECA", "color": "#FEEECA"}}, {"label": "Service Content", "value": "", "style": {"backgroundColor": "#E4F7E0", "color": "#E4F7E0"}}, {"label": "Price Negotiation", "value": "", "style": {"backgroundColor": "#CFEFF4", "color": "#CFEFF4"}}, {"label": "Expected Outcomes", "value": "", "style": {"backgroundColor": "#D5F5EF", "color": "#D5F5EF"}}, {"label": "Cooperation Process", "value": "", "style": {"backgroundColor": "#BED3E5", "color": "#BED3E5"}}, {"label": "Technical Capability", "value": "", "style": {"backgroundColor": "#EBDEED", "color": "#EBDEED"}}, {"label": "Team Configuration", "value": "", "style": {"backgroundColor": "#E6C2D8", "color": "#E6C2D8"}}, {"label": "Service Standards", "value": "", "style": {"backgroundColor": "#ECC8BA", "color": "#ECC8BA"}}, {"label": "Industry Experience", "value": "", "style": {"backgroundColor": "#F7F8D2", "color": "#F7F8D2"}}, {"label": "Effect Evaluation", "value": "", "style": {"backgroundColor": "#E2E4EB", "color": "#E2E4EB"}}, {"label": "Risk Control", "value": "", "style": {"backgroundColor": "#E3EBE5", "color": "#E3EBE5"}}, {"label": "Value-added Services", "value": "", "style": {"backgroundColor": "#BDDFDB", "color": "#BDDFDB"}}, {"label": "Cooperation Model", "value": "", "style": {"backgroundColor": "#7EA6CA", "color": "#7EA6CA"}}, {"label": "Client Cases", "value": "", "style": {"backgroundColor": "#D7BDDA", "color": "#D7BDDA"}}, {"label": "Industry Trends", "value": "", "style": {"backgroundColor": "#CC85B1", "color": "#CC85B1"}}, {"label": "Service Commitment", "value": "", "style": {"backgroundColor": "#DC9A80", "color": "#DC9A80"}}, {"label": "Contract Terms", "value": "", "style": {"backgroundColor": "#EEF0A5", "color": "#EEF0A5"}}, {"label": "Technical Support", "value": "", "style": {"backgroundColor": "#C4C8D6", "color": "#C4C8D6"}}, {"label": "Summary", "value": "", "style": {"backgroundColor": "#C6D7CB", "color": "#C6D7CB"}}] , name = "categoryOfTopics" , color = True , placeholder = "" , allowManualInput = False , mulLevelSelectionConfig = {"sortFieldName": "", "sortBy": "", "matchFieldName": "", "dataSourceModel": "", "filterValue": ""})
    problem = datatypes.Ltext(title = "Question" , isAllowScan = False , name = "problem")
    standardAnswers = datatypes.Ltext(title = "Standard Answers" , isAllowScan = False , name = "standardAnswers")
    fractionalValue = datatypes.Numeric(title = "Fractional Value" , decimal = 0 , unit = "" , placeholder = "" , name = "fractionalValue")
    class Meta:
        name = "QuestionModel"
        title = "Question Bank"
        modelType = "NormalType"
        dataTitle = "problem"
        db = "databases.Default"
        dbTable = "QuestionModel"
        unionIndexList = []
        unionUniqueList = []
