
import { Button, message, Modal, Input, theme } from 'antd';
import { useState, useEffect, useRef, useMemo } from "react";
import { Jit } from 'jit';


const Render = (props) => {
    const compIns = props.compIns;
    const { token } = theme.useToken();

    const [ready, setReady] = useState(location.href.indexOf("/Ide/") !== -1 || location.href.indexOf("/ide/") !== -1)
    const [loading, setLoading]  = useState(false);
    const [questions,  setQuestions] = useState([]); 
    const [submited, setSubmited] = useState(false);
    const stashKey = `${compIns.app.appId}-${compIns.page.fullName}-${compIns.name}-${compIns.page.responseId.value}`;

    
    const answerRef = useRef([]);

    const stashData = useMemo(() => {
        const answerDict = {};
        const data = localStorage.getItem(stashKey);
        if(data){
            const answers = JSON.parse(data);
            answers.forEach(a => {
                answerDict[a.qid] = a.answer;
            })
        }
        return answerDict;
    }, []);


    useEffect(() => {
      if(ready){
        compIns.page.app.modules.FeedBack.openLoading("Loading...");
        setLoading(true);
        compIns.getQuestions(1).then(qs => {
          setQuestions(qs);
          compIns.page.app.modules.FeedBack.closeLoading();
          compIns.startTime = GlobalVar.currentTime.getDisplayValue();
          const stashQs = answerRef.current;
          answerRef.current = [];
          qs.forEach(q => {
            answerRef.current.push({
              paperQid: q.id,
              qid: q.title.id,
              answer: stashData[q.title.id],
              fractionalValue: q.fractionalValue
            })
          })
        })
      }
    }, [ready]);

    const submitAnswer = () => {
        const noAnswers = answerRef.current.filter(a => !a.answer);
        const confirmText = noAnswers.length ? "You haven't answered all questions yet. Are you sure you want to submit?" : "Are you sure you want to submit?";
        Modal.confirm({
            title: 'Confirm',
            content: confirmText,
            onOk() {
                const questionAndAnswers = answerRef.current.map(a => {
                    return {
                        relateQuestion: {id: a.qid},
                        fractionalValue: a.fractionalValue,
                        answer: a.answer
                    }
                });
                compIns.submitAnswer(questionAndAnswers).then(res => {
                    setSubmited(true);
                });
            },
            onCancel() {
                console.log('Cancel');
            },
        });
      
    }

    const stashAnswer = () => {
        if(answerRef.current?.length){
            localStorage.setItem(stashKey, JSON.stringify(answerRef.current));
            message.success("Saved");
        }
    }


    return (
        <div
            style={{
                width: "100%",
                height: "calc(100% - 20px)",
                background: `linear-gradient(to bottom, ${token.colorPrimary}80, #ffffff80)`,
                position: "fixed",
                top: 0,
                left: 0,
                paddingTop:20
            }}
        >
            <div style={{ 
                height: "100%", 
                overflowY: "hidden",
                display: "flex",
                flexDirection: "column",
                alignItems: "center",
                width: "100%",
                padding: "0px 20px",
                gap:20,
                maxWidth: 960,
                margin: "0 auto",
                borderRadius: "8px 8px 0px 0px",
                background: "#fff"
            }}>
                <Modal
                open={!ready}
                footer={null}
                closable={false}
                getContainer={false}
                >
                    {
                        compIns.page.myResponse.status.value === 'answered' ? 
                        <div style={{ textAlign: "center" }}>You have completed this exam</div> : 
                        <>
                            <div>
                                <h2 style={{ paddingLeft: 30 }}>
                                {compIns.page.myResponse.testPapers.name.value}
                                </h2>
                                <div style={{ paddingLeft: 30 }}>
                                <span>Examinee: &nbsp;&nbsp;</span>
                                <span>{GlobalVar.currentUser.getName()}</span>
                                </div>
                                <div style={{ paddingLeft: 30 }}>
                                <span>Exam Date: &nbsp;&nbsp;</span>
                                <span>{GlobalVar.currentTime.date}</span>
                                </div>
                            </div>

                            <div style={{ marginTop: 40, display: "flex", justifyContent: "flex-end" }}>
                                <Button type="primary" onClick={() => setReady(true)}>Ready, Start Exam</Button>
                            </div>
                        </>
                    
                    }
                
                </Modal>

                {
                    questions.length > 0 && !submited ? 
                        <div style={{ 
                            width: "100%",
                            height: 40, 
                            display: "flex", 
                            justifyContent: "space-between",
                            paddingBottom: 20,
                            borderBottom: `1px solid ${token.colorPrimary}`,
                            alignItems: "flex-end"
                        }}
                        >
                            <span
                                style={{
                                    fontSize: 28,
                                    fontWeight: 700,
                                    color: `${token.colorPrimary}`,
                                }}
                            >{compIns.page.myResponse.testPapers.name.value}</span>
                            <span
                                style={{
                                    fontSize: 14,
                                    color: "#64748b",
                                    padding: "8px 16px",
                                    backgroundColor: "#f1f5f9",
                                    borderRadius: "8px",
                                }}
                            >
                                Examinee: &nbsp;&nbsp;{GlobalVar.currentUser.getName()}
                            </span>
                        </div> : null
                }

                <div
                style={{
                    display: "flex",
                    flexDirection: "column",
                    alignItems: "center",
                    gap: 20,
                    width: "100%",
                    overflowY: "auto",
                    paddingBottom:20
                }}
                >
                {
                    questions.map(qs => {
                    const qResult = answerRef.current.find(a => a.paperQid === qs.id && a.qid === qs.title.id);
                    
                    return (
                        <div 
                        key={qs.id}
                        style={{
                            textAlign: "left",
                            width: "100%"
                        }}
                        >
                        <h3>{`${qs.serialNumber}. ${qs.title.problem} (${qs.fractionalValue}分)`}</h3>
                        <div>
                            {
                                submited ? 
                                (
                                    <div>
                                        <span>Your Answer:</span>
                                        {qResult?.answer || "Not answered"}
                                    
                                    </div>
                                )
                                : 
                                    <Input.TextArea 
                                        rows={3} 
                                        placeholder="Please answer here"
                                        defaultValue={stashData[qResult.qid]}
                                        onChange={e => {
                                            if(qResult){
                                                qResult.answer = e.target.value.trim();
                                            }
                                        }}
                                    />
                            }
                            
                        </div>
                        </div>
                    
                    )
                    })
                }
                </div>
                {
                    questions.length > 0 && !submited ? 
                        <div style={{ 
                            width: "100%",
                            height: 40, 
                            display: "flex", 
                            justifyContent: "center",
                            borderTop: `1px solid ${token.colorPrimary}`,
                            padding: "20px 0px",
                            gap: 20,
                        }}>
                            <Button onClick={stashAnswer}>Save</Button>
                            <Button type="primary" onClick={submitAnswer} style={{ marginRight: 10 }}>Submit</Button>
                        </div> : null
                }
            </div>
        </div>
    );
};

// 这是自定义组件逻辑处理类，逻辑部分在这里实现，它是一个javascript的class
export default class BlankComponent1 extends Jit.BaseComponent {
    // 将自定义组件的渲染器挂载到组件逻辑对象上
    Render = Render;

    /**
     * 获取数据，页面的方法
     */
    startTime = new Date();

    async getQuestions(){
      this.page.myResponse.otherOrganiser.value = GlobalVar.currentTime.getDisplayValue();
      const questions = this.page.myResponse.testPapers.titleDetails.value;
      const qIds = questions.map(q => q.title.id);
      const result = await this.app.models.QuestionModel.query(Q(Q("id", "in", qIds)), ["id", "problem"], null, 1, 100, 0)
      const qDict = {};
      result.rowDatas.value.forEach(q => {
        qDict[q.id] = q;
      });
      questions.forEach(q => {
        q.question = qDict[q.title.id];
      })
      return questions;
    }

    async submitAnswer(questionAndAnswers){
        this.page.myResponse.detailsOfResponses.value = questionAndAnswers;
        this.page.myResponse.submissionTime.value = GlobalVar.currentTime.getDisplayValue();
        this.page.myResponse.dateOfExamination.value = GlobalVar.today.getDisplayValue();
        this.page.myResponse.status.value = "answered";
        await this.page.myResponse.save(0);
    }
}

