import type { ComponentPageScheme } from "jit";
import { Jit } from "jit";
import schemeJson from "./scheme.json";
type BaseComponent = InstanceType<typeof Jit.BaseComponent>;

class PageCls extends Jit.GridPage {
    Form4!: BaseComponent;
    Modal3!: BaseComponent;
    Table2!: BaseComponent;
    Filter1!: BaseComponent;
    scheme: ComponentPageScheme = schemeJson;

    bindEvent() {
        this.Filter1.subscribeEvent("afterFilter", async () => {
            await this.Table2.call(this.Filter1.filter.value);
        });

        this.Table2.subscribeEvent("clicksckgJa", async () => {
            this.Modal3.call(undefined);
            this.Form4.mode.value = "read";
            this.Form4.formData.value = this.Table2.activeRow.value;
        });

        this.Table2.subscribeEvent("clickzHwsmj", async () => {
            this.app.modules.Util.openPage({
                "linkType": "INNER",
                "openType": "CURRENT_SHELL",
                "shellMenu": ["candidatePortal", "examinations"],

                "pageVariable": {
                    "responseId": {
                        "valueType": "Variable",
                        "value": this.Table2.activeRow.id.value
                    }
                }
            });
        });
    }
}

export default PageCls;